clear;clc;
close all;

MeMAIN

%% Output
figure;
plot(ratio,EPsim,'r','LineStyle','--',LineWidth=1)
hold on
plot(ratio,EPsif,'b',"LineStyle","-",LineWidth=1)
xlabel('Sex ratio')
ylabel('Proportion of skilled agent') 
legend('Male','Female')
title('Education Decision')

%% Trend line of sex ratio
[data,~,~] = xlsread('E:\Project1_empirical\Statistical evidence\Sex ratio.xlsx', 'Line-fit','A2:D44');
year = data(:,1);
sr_urban = data(:,3);
figure;
plot(year,sr_urban,'r-','LineStyle','-.',LineWidth=1.2)
fit_aux = polyfit(year,sr_urban,1);
sr_urban_aux = polyval(fit_aux,year);
hold on 
plot(year,sr_urban_aux,'b','LineStyle','-','LineWidth',1)
xlabel('Year')
ylabel('Sex ratio at birth of Urban China')
legend('','trend line')
title('Sex ratio at birth')

%% Proportion of skilled agent from census
[data2,~,~] = xlsread('E:\Project1_empirical\Statistical evidence\Skilled Share\Education share.xlsx','Plot','A3:E6');
year2 = data2(:,1);
Psim2035 = data2(:,2);
Psif2035 = data2(:,3);
Psim2030 = data2(:,4);
Psif2030 = data2(:,5);
figure;
plot(year2,Psim2035,'b','LineStyle','-.','LineWidth',1)
hold on
plot(year2,Psif2035,'k','LineStyle','-','LineWidth',1)
xlabel('Year')
ylabel('Proportion of skilled agent') 
legend('Male','Female')
title('Skilled Share from Census')
